<?php
/**
 *
 * Let's Review Helpers
 *
 * @since      3.0.0
 *
 * @package    Let's Review
 * @subpackage lets-review/admin
 */

class Lets_Review_Helpers {

	/**
	 * Get score array
	 *
	 * @since 1.0.0
	 */
	public static function lets_review_get_convert_to_all_scores( $args = array() ) {
		if ( ! isset( $args['score'] ) || ! isset( $args['scoreType'] ) ) {
			return;
		}
		$args['max'] = empty( $args['max'] ) ? 100 : $args['max'];
		if ( is_array( $args['score'] ) ) {
			$output = array();
			foreach ( $args['score'] as $key => $value ) {
				if ( ! isset( $value['score'] ) ) {
					continue;
				}
				$output[] = self::lets_review_convert_to_all_scores( $value['score'], $args['scoreType'], $value['title'], $args['max'] );
			}
		} else {
			$output = self::lets_review_convert_to_all_scores( $args['score'], $args['scoreType'], '', $args['max'] );
		}
		return $output;
	}

	/**
	 * Pros/cons cleanup
	 *
	 * @since    3.0.0
	 */
	public static function lets_review_cleanup_pros_cons( $pros_cons = array(), $prop = '' ) {
		if ( empty( $pros_cons ) ) {
			return array();
		}
		if ( is_string( $pros_cons ) ) {
			$pros_cons = explode( apply_filters( 'lets_review_backend_delimiter', ',' ), $pros_cons );
		}
		$pros_cons = array_filter( $pros_cons );
		if ( empty( $pros_cons ) ) {
			return;
		}
		foreach ( $pros_cons as $key => $value ) {
			$val               = ! empty( $prop ) ? $value[ $prop ] : $value;
			$pros_cons[ $key ] = array(
				'title' => $val,
			);
		}
		return $pros_cons;
	}

	/**
	 * Affiliate cleanup
	 *
	 * @since    3.0.0
	 */
	public static function lets_review_cleanup_aff( $affs = array() ) {
		if ( empty( $affs ) ) {
			return array();
		}
		$affs_new = array();
		if ( is_string( $affs ) ) {
			$aff_blocks = explode( apply_filters( 'lets_review_backend_delimiter', ',' ), $affs );
			foreach ( $aff_blocks as $key => $value ) {
				if ( 0 == $key % 2 ) {
					$affs_new[ $key ] = array(
						'title' => $value,
					);
				} else {
					$affs_new[ $key - 1 ]['url'] = $value;
				}
			}
			$affs = $affs_new;
		}

		foreach ( $affs as $key => $value ) {
			$affs[ $key ] = array(
				'content' => '<a href="' . $value['url'] . '">' . $value['title'] . '</a>',
			);
		}
		return $affs;
	}

	/**
	 * Conversion helper
	 *
	 * @since    3.0.0
	 */
	public static function lets_review_convert_to_all_scores( $score = '', $score_type = 1, $title = '', $max = 100 ) {
		$score = $score > $max ? $max : (float) $score;
		if ( 2 == $score_type ) {
			$f_score_10  = $score;
			$f_score_100 = (int) ( $f_score_10 * 10 );
			$f_score_5   = $f_score_100 / 20;
		} elseif ( 1 == $score_type ) {
			$f_score_100 = $score;
			$f_score_10  = $f_score_100 / 10;
			$f_score_5   = $f_score_100 / 20;
		} else {
			$f_score_5   = $score;
			$f_score_10  = $f_score_5 * 2;
			$f_score_100 = (int) ( $f_score_5 * 20 );
		}
		$output = array(
			'outof5'   => $f_score_5,
			'outof10'  => $f_score_10,
			'outof100' => $f_score_100,
		);
		if ( ! empty( $title ) ) {
			$output['title'] = $title;
		}
		return $output;
	}

	/**
	 * User Rating helper
	 *
	 * @since    3.0.0
	 */
	public static function lets_review_get_ur_final_score( $args = array() ) {
		$output = array();
		$prefix = empty( $args['sc_pid'] ) ? '' : $args['sc_pid'];
		$suffix = $args['uid'];
		if ( empty( $prefix ) ) {
			$prefix = empty( $args['pid'] ) ? '' : $args['pid'];
			$suffix = '';
		}
		if ( $prefix > 1 && ! isset( Lets_Review_Options::$lets_review_options['lets_review_user_ratings'][ $args['uid'] ] ) ) {
			$args['final_score'] = get_post_meta( $prefix, '_lets_review_user_rating' . $suffix, true ) ? get_post_meta( $prefix, '_lets_review_user_rating' . $suffix, true ) : 0;
			$new_votes           = get_post_meta( $prefix, '_lets_review_user_rating_vote_count' . $suffix, true ) ? get_post_meta( $prefix, '_lets_review_user_rating_vote_count' . $suffix, true ) : 0;
			Lets_Review_Options::lets_review_set_user_ratings();
			Lets_Review_Options::$lets_review_options['lets_review_user_ratings'][ $args['uid'] ] = array(
				'votes' => $new_votes,
				'score' => array(
					'outof100' => $args['final_score'],
					'outof10'  => $args['final_score'] / 10,
					'outof5'   => number_format( ( $args['final_score'] / 20 ), 1 ) + 0,
				),
			);
			Lets_Review_Options::lets_review_update_option();
		}
		if ( isset( Lets_Review_Options::$lets_review_options['lets_review_user_ratings'][ $args['uid'] ] ) ) {
			$output['votes'] = Lets_Review_Options::$lets_review_options['lets_review_user_ratings'][ $args['uid'] ]['votes'];
			$output['score'] = Lets_Review_Options::$lets_review_options['lets_review_user_ratings'][ $args['uid'] ]['score'];
		} else {
			$output['votes'] = 0;
			$output['score'] = array(
				'outof100' => 0,
				'outof10'  => 0,
				'outof5'   => 0,
			);
		}
		return $output;
	}

	/**
	 * Post Types helper
	 *
	 * @since    3.0.0
	 */
	public static function lets_review_get_post_types( $args = array() ) {
		$attachment     = empty( $args['attachment'] ) ? false : $args['attachment'];
		$args['output'] = empty( $args['output'] ) ? 'names' : $args['output'];
		$cpt_args       = array(
			'public' => true,
		);
		if ( isset( $args['builtin'] ) ) {
			$cpt_args['_builtin'] = $args['builtin'];
		}
		$output = get_post_types( $cpt_args, $args['output'] );

		if ( isset( $args['builtin'] ) || ! empty( $args['essentials'] ) ) {
			unset( $output['topic'] );
			unset( $output['reply'] );
			unset( $output['forum'] );
			unset( $output['elementor_library'] );
			unset( $output['guest-author'] );
		}

		if ( empty( $attachment ) ) {
			unset( $output['attachment'] );
		}

		return $output;
	}

	/**
	 * Args helper
	 *
	 * @since    3.0.0
	 */
	public static function lets_review_args( $args = array() ) {
		$args['scoreTypeProp'] = 'outof100';
		$args['max']           = 100;
		$args['scoreType']     = empty( $args['scoreType'] ) ? 1 : $args['scoreType'];
		if ( 2 == $args['scoreType'] ) {
			$args['scoreTypeProp'] = 'outof10';
			$args['max']           = 10;
		} elseif ( $args['scoreType'] > 2 ) {
			$args['scoreTypeProp'] = 'outof5';
			$args['max']           = 5;
		}
		$args['skinTitles']        = empty( $args['skinTitles'] ) ? '' : $args['skinTitles'];
		$args['skinFinalScore']    = empty( $args['skinFinalScore'] ) ? '#fff' : $args['skinFinalScore'];
		$args['design']            = empty( $args['design'] ) ? '1' : $args['design'];
		$args['accent']            = empty( $args['accent'] ) ? '#f8d92f' : $args['accent'];
		$args['crits']             = empty( $args['crits'] ) ? array() : $args['crits'];
		$args['type']              = empty( $args['type'] ) ? 1 : $args['type'];
		$args['skin']              = empty( $args['skin'] ) ? 1 : $args['skin'];
		$args['skin']              = self::lets_review_get_skin( $args['skin'], $args['design'] );
		$args['itemReviewedTitle'] = empty( $args['title'] ) ? '' : $args['title'];
		return $args;
	}

	/**
	 * Skin helper
	 *
	 * @since    3.0.0
	 */
	public static function lets_review_get_skin( $skin = 1, $design = '' ) {
		if ( 4 == $design || 3 == $design ) {
			$skin = 1;
		}
		return $skin;
	}

	/**
	 * Accent color helper
	 *
	 * @since    3.0.0
	 */
	public static function lets_review_get_accent( $args = '' ) {
		$color = empty( $args['accent'] ) ? get_post_meta( $args['pid'], '_lets_review_color', true ) : $args['accent'];
		if ( empty( $color ) ) {
			$color = get_option( 'lets_review_gd_color', '#f8d92f' );
		}
		return $color;
	}

	/**
	 * Let's Review Schema
	 *
	 * @since    3.0.0
	 */
	public static function lets_review_schema( $args = '' ) {
		if ( ! empty( $_GET['ipl'] ) || apply_filters( 'lets_review_disable_schema', false ) ) {
			return;
		}
		$schema_type = empty( $args['schema_type'] ) ? get_post_meta( $pid, '_lets_review_type', true ) : $args['schema_type'];

		if ( get_option( 'lets_review_schema_onoff', 1 ) != 1 || ( 3 == $schema_type && empty( $args['votes'] ) ) || ( ! empty( $args['top_box'] ) && 5 != $args['location'] ) ) {
			return;
		}

		if ( ! empty( $args['schema'] ) && 'off' == $args['schema'] ) {
			return;
		}

		if ( empty( $args['pid'] ) ) {
			global $post;
			$args['pid'] = $post->ID;
		}
		$pid                 = $args['pid'];
		$item_reviewed       = empty( $args['itemReviewed'] ) ? get_post_meta( $pid, '_lets_review_schema_item_reviewed', true ) : $args['itemReviewed'];
		$item_reviewed       = empty( $item_reviewed ) ? 'Organization' : $item_reviewed;
		$date                = get_the_date( 'c', $pid );
		$mod_date            = get_the_modified_time( 'c', $pid );
		$url                 = get_permalink( $pid );
		$id                  = empty( $args['uid'] ) ? 'lets-review-box-' . $pid : $args['uid'];
		$id                  = trailingslashit( $url ) . $id;
		$aid                 = get_the_author_meta( 'display_name', get_post_field( 'post_author', $pid ) );
		$item_reviewed_title = empty( $args['itemReviewedTitle'] ) ? get_post_meta( $pid, '_lets_review_title', true ) : $args['itemReviewedTitle'];
		$item_reviewed_title = empty( $item_reviewed_title ) ? get_the_title( $pid ) : $item_reviewed_title;
		$worst_rating        = 0;
		$type                = 3 == $schema_type ? 'AggregateRating' : 'Review';

		$schema_extra = array();
		$schema_sku   = empty( $args['schemaSku'] ) ? get_post_meta( $pid, '_lets_review_schema_sku', true ) : $args['schemaSku'];
		if ( 'Product' == $item_reviewed && ! empty( $schema_sku ) ) {
			$schema_extra['sku'] = $schema_sku;
		}
		$schema_mpn = empty( $args['schemaMpn'] ) ? get_post_meta( $pid, '_lets_review_schema_mpn', true ) : $args['schemaMpn'];
		if ( 'Product' == $item_reviewed && ! empty( $schema_mpn ) ) {
			$schema_extra['mpn'] = $schema_mpn;
		}
		$schema_description = empty( $args['schemaDescription'] ) ? get_post_meta( $pid, '_lets_review_schema_description', true ) : $args['schemaDescription'];
		if ( 'Product' == $item_reviewed && ! empty( $schema_description ) ) {
			$schema_extra['description'] = $schema_description;
		}
		$schema_brand = empty( $args['schemaBrand'] ) ? get_post_meta( $pid, '_lets_review_schema_brand', true ) : $args['schemaBrand'];
		if ( 'Product' == $item_reviewed && ! empty( $schema_brand ) ) {
			$schema_extra['brand'] = '{ "@type": "Brand", "name": "' . $schema_brand . '" }';
		}
		$schema_director = empty( $args['schemaDirector'] ) ? get_post_meta( $pid, '_lets_review_schema_director', true ) : $args['schemaDirector'];
		if ( 'Movie' == $item_reviewed && ! empty( $schema_director ) ) {
			$schema_extra['director'] = $schema_director;
		}
		$schema_date_created = empty( $args['schemaDateCreated'] ) ? get_post_meta( $pid, '_lets_review_schema_date_created', true ) : $args['schemaDateCreated'];
		if ( 'Movie' == $item_reviewed && ! empty( $schema_date_created ) ) {
			$schema_extra['dateCreated'] = $schema_date_created;
		}
		if ( 3 == $schema_type ) {
			if ( $args['votes'] < 1 ) {
				return;
			}
		}
		echo '<script type="application/ld+json">{"@context": "http://schema.org/",
			"@type": "' . esc_attr( $item_reviewed ) . '",
			"name": "' . esc_attr( $item_reviewed_title ) . '",';

		if ( ! empty( $schema_extra ) ) {
			foreach ( $schema_extra as $key => $value ) {
				echo '"' . esc_attr( $key ) . '": "' . esc_attr( $value ) . '",';
			}
		}
		$image_url = empty( $args['fiID'] ) ? get_the_post_thumbnail_url( $pid ) : wp_get_attachment_image_src( $args['fiID'], 'full' );
		$image_url = is_array( $image_url ) ? $image_url[0] : $image_url;
		if ( ! empty( $image_url ) ) {
			echo '"image": [
				"' . esc_url( $image_url ) . '"
			],';
		}
		if ( 1 == $schema_type || 2 == $schema_type ) {

			$rating_value = empty( $args['score'] ) ? get_post_meta( $pid, '_lets_review_final_score', true ) : $args['score'][ $args['scoreTypeProp'] ];
			echo '"review": {
				"@type": "Review",
				"reviewRating": {
					"@type": "Rating",
					"worstRating": "' . esc_attr( $worst_rating ) . '",
					"ratingValue": "' . esc_attr( $rating_value ) . '",
					"bestRating": "' . esc_attr( $args['max'] ) . '"
				},
				"author": {
					"@type": "Person",
					"name": "' . esc_attr( $aid ) . '"
				}
			}';
		}
		if ( 1 == $schema_type || 3 == $schema_type ) {
			$rating_value = ! isset( $args['ur_score'] ) ? get_post_meta( $pid, '_lets_review_user_rating' . $args['uid'], true ) : $args['ur_score'][ $args['scoreTypeProp'] ];
			$rating_value = empty( $rating_value ) ? 0 : $rating_value;
			if ( $args['votes'] > 0 ) {
				if ( 1 == $schema_type ) {
					echo ',';
				}
				echo '"aggregateRating": {
					"@type": "AggregateRating",
					"ratingValue": "' . esc_attr( $rating_value ) . '",
					"worstRating": "' . esc_attr( $worst_rating ) . '",
					"bestRating": "' . esc_attr( $args['max'] ) . '",
					"ratingCount": "' . esc_attr( $args['votes'] ) . '"
				}';
			}
		}
		echo '}</script>';

	}
}
